package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{Value, TagKey}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagValues(
    key: Option[TagKey] = None,
    values: Option[Iterable[Value]] = None,
    matchOptions: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.MatchOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.TagValues = {
    import TagValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TagValues
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        matchOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchOptionsWithStrings)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.TagValues.wrap(buildAwsValue())
}
object TagValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.TagValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.TagValues =
      io.github.vigoo.zioaws.costexplorer.model.TagValues(
        keyValue.map(value => value),
        valuesValue.map(value => value),
        matchOptionsValue.map(value => value)
      )
    def keyValue: Option[TagKey]
    def valuesValue: Option[List[Value]]
    def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]]
    def key: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def values: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("values", valuesValue)
    def matchOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.MatchOption
    ]] = AwsError.unwrapOptionField("matchOptions", matchOptionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.TagValues
  ) extends io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly {
    override def keyValue: Option[TagKey] =
      scala.Option(impl.key()).map(value => value: TagKey)
    override def valuesValue: Option[List[Value]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: Value
        }.toList
      )
    override def matchOptionsValue
        : Option[List[io.github.vigoo.zioaws.costexplorer.model.MatchOption]] =
      scala
        .Option(impl.matchOptions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.costexplorer.model.MatchOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.TagValues
  ): io.github.vigoo.zioaws.costexplorer.model.TagValues.ReadOnly = new Wrapper(
    impl
  )
}
