package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriberType {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberType
}
object SubscriberType {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.SubscriberType
  ): io.github.vigoo.zioaws.costexplorer.model.SubscriberType = value match {
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberType.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberType =
      software.amazon.awssdk.services.costexplorer.model.SubscriberType.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberType =
      software.amazon.awssdk.services.costexplorer.model.SubscriberType.EMAIL
  }
  case object SNS
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberType =
      software.amazon.awssdk.services.costexplorer.model.SubscriberType.SNS
  }
}
