package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriberStatus {
  def unwrap
      : software.amazon.awssdk.services.costexplorer.model.SubscriberStatus
}
object SubscriberStatus {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus
  ): io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus = value match {
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.CONFIRMED =>
      val r = CONFIRMED
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.DECLINED =>
      val r = DECLINED
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberStatus =
      software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIRMED
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberStatus =
      software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.CONFIRMED
  }
  case object DECLINED
      extends io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SubscriberStatus =
      software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.DECLINED
  }
}
