package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.SubscriberAddress
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Subscriber(
    address: Option[SubscriberAddress] = None,
    `type`: Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberType] =
      None,
    status: Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Subscriber = {
    import Subscriber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Subscriber
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Subscriber.wrap(buildAwsValue())
}
object Subscriber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Subscriber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Subscriber =
      io.github.vigoo.zioaws.costexplorer.model.Subscriber(
        addressValue.map(value => value),
        typeValue.map(value => value),
        statusValue.map(value => value)
      )
    def addressValue: Option[SubscriberAddress]
    def typeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberType]
    def statusValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus]
    def address: ZIO[Any, AwsError, SubscriberAddress] =
      AwsError.unwrapOptionField("address", addressValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SubscriberType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Subscriber
  ) extends io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly {
    override def addressValue: Option[SubscriberAddress] =
      scala.Option(impl.address()).map(value => value: SubscriberAddress)
    override def typeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.SubscriberType.wrap(value)
        )
    override def statusValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.SubscriberStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Subscriber
  ): io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly =
    new Wrapper(impl)
}
