package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.SortDefinitionKey
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SortDefinition(
    key: SortDefinitionKey,
    sortOrder: Option[io.github.vigoo.zioaws.costexplorer.model.SortOrder] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SortDefinition = {
    import SortDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SortDefinition
      .builder()
      .key(key: java.lang.String)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SortDefinition
      .wrap(buildAwsValue())
}
object SortDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SortDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.SortDefinition =
      io.github.vigoo.zioaws.costexplorer.model
        .SortDefinition(keyValue, sortOrderValue.map(value => value))
    def keyValue: SortDefinitionKey
    def sortOrderValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SortOrder]
    def key: ZIO[Any, Nothing, SortDefinitionKey] = ZIO.succeed(keyValue)
    def sortOrder: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrderValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SortDefinition
  ) extends io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly {
    override def keyValue: SortDefinitionKey = impl.key(): SortDefinitionKey
    override def sortOrderValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SortOrder.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SortDefinition
  ): io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly =
    new Wrapper(impl)
}
