package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansSavings(
    netSavings: Option[GenericString] = None,
    onDemandCostEquivalent: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings = {
    import SavingsPlansSavings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings
      .builder()
      .optionallyWith(netSavings.map(value => value: java.lang.String))(
        _.netSavings
      )
      .optionallyWith(
        onDemandCostEquivalent.map(value => value: java.lang.String)
      )(_.onDemandCostEquivalent)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings
      .wrap(buildAwsValue())
}
object SavingsPlansSavings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings(
        netSavingsValue.map(value => value),
        onDemandCostEquivalentValue.map(value => value)
      )
    def netSavingsValue: Option[GenericString]
    def onDemandCostEquivalentValue: Option[GenericString]
    def netSavings: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("netSavings", netSavingsValue)
    def onDemandCostEquivalent: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("onDemandCostEquivalent", onDemandCostEquivalentValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly {
    override def netSavingsValue: Option[GenericString] =
      scala.Option(impl.netSavings()).map(value => value: GenericString)
    override def onDemandCostEquivalentValue: Option[GenericString] = scala
      .Option(impl.onDemandCostEquivalent())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly =
    new Wrapper(impl)
}
