package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansPurchaseRecommendationMetadata(
    recommendationId: Option[GenericString] = None,
    generationTimestamp: Option[GenericString] = None,
    additionalMetadata: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata = {
    import SavingsPlansPurchaseRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
      .builder()
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        generationTimestamp.map(value => value: java.lang.String)
      )(_.generationTimestamp)
      .optionallyWith(additionalMetadata.map(value => value: java.lang.String))(
        _.additionalMetadata
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
      .wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata =
      io.github.vigoo.zioaws.costexplorer.model
        .SavingsPlansPurchaseRecommendationMetadata(
          recommendationIdValue.map(value => value),
          generationTimestampValue.map(value => value),
          additionalMetadataValue.map(value => value)
        )
    def recommendationIdValue: Option[GenericString]
    def generationTimestampValue: Option[GenericString]
    def additionalMetadataValue: Option[GenericString]
    def recommendationId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("generationTimestamp", generationTimestampValue)
    def additionalMetadata: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("additionalMetadata", additionalMetadataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: Option[GenericString] =
      scala.Option(impl.recommendationId()).map(value => value: GenericString)
    override def generationTimestampValue: Option[GenericString] = scala
      .Option(impl.generationTimestamp())
      .map(value => value: GenericString)
    override def additionalMetadataValue: Option[GenericString] =
      scala.Option(impl.additionalMetadata()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly =
    new Wrapper(impl)
}
