package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait SavingsPlansDataType {
  def unwrap
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType
}
object SavingsPlansDataType {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType =
    value match {
      case software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.ATTRIBUTES =>
        val r = ATTRIBUTES
        r
      case software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.UTILIZATION =>
        val r = UTILIZATION
        r
      case software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.AMORTIZED_COMMITMENT =>
        val r = AMORTIZED_COMMITMENT
        r
      case software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.SAVINGS =>
        val r = SAVINGS
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType =
      software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object ATTRIBUTES
      extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType =
      software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.ATTRIBUTES
  }
  case object UTILIZATION
      extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType =
      software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.UTILIZATION
  }
  case object AMORTIZED_COMMITMENT
      extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType =
      software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.AMORTIZED_COMMITMENT
  }
  case object SAVINGS
      extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDataType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType =
      software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType.SAVINGS
  }
}
