package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansAmortizedCommitment(
    amortizedRecurringCommitment: Option[GenericString] = None,
    amortizedUpfrontCommitment: Option[GenericString] = None,
    totalAmortizedCommitment: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment = {
    import SavingsPlansAmortizedCommitment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment
      .builder()
      .optionallyWith(
        amortizedRecurringCommitment.map(value => value: java.lang.String)
      )(_.amortizedRecurringCommitment)
      .optionallyWith(
        amortizedUpfrontCommitment.map(value => value: java.lang.String)
      )(_.amortizedUpfrontCommitment)
      .optionallyWith(
        totalAmortizedCommitment.map(value => value: java.lang.String)
      )(_.totalAmortizedCommitment)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment
      .wrap(buildAwsValue())
}
object SavingsPlansAmortizedCommitment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment(
        amortizedRecurringCommitmentValue.map(value => value),
        amortizedUpfrontCommitmentValue.map(value => value),
        totalAmortizedCommitmentValue.map(value => value)
      )
    def amortizedRecurringCommitmentValue: Option[GenericString]
    def amortizedUpfrontCommitmentValue: Option[GenericString]
    def totalAmortizedCommitmentValue: Option[GenericString]
    def amortizedRecurringCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "amortizedRecurringCommitment",
        amortizedRecurringCommitmentValue
      )
    def amortizedUpfrontCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "amortizedUpfrontCommitment",
        amortizedUpfrontCommitmentValue
      )
    def totalAmortizedCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "totalAmortizedCommitment",
        totalAmortizedCommitmentValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly {
    override def amortizedRecurringCommitmentValue: Option[GenericString] =
      scala
        .Option(impl.amortizedRecurringCommitment())
        .map(value => value: GenericString)
    override def amortizedUpfrontCommitmentValue: Option[GenericString] = scala
      .Option(impl.amortizedUpfrontCommitment())
      .map(value => value: GenericString)
    override def totalAmortizedCommitmentValue: Option[GenericString] = scala
      .Option(impl.totalAmortizedCommitment())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly =
    new Wrapper(impl)
}
