package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RightsizingRecommendationSummary(
    totalRecommendationCount: Option[GenericString] = None,
    estimatedTotalMonthlySavingsAmount: Option[GenericString] = None,
    savingsCurrencyCode: Option[GenericString] = None,
    savingsPercentage: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary = {
    import RightsizingRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary
      .builder()
      .optionallyWith(
        totalRecommendationCount.map(value => value: java.lang.String)
      )(_.totalRecommendationCount)
      .optionallyWith(
        estimatedTotalMonthlySavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedTotalMonthlySavingsAmount)
      .optionallyWith(
        savingsCurrencyCode.map(value => value: java.lang.String)
      )(_.savingsCurrencyCode)
      .optionallyWith(savingsPercentage.map(value => value: java.lang.String))(
        _.savingsPercentage
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary
      .wrap(buildAwsValue())
}
object RightsizingRecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary =
      io.github.vigoo.zioaws.costexplorer.model
        .RightsizingRecommendationSummary(
          totalRecommendationCountValue.map(value => value),
          estimatedTotalMonthlySavingsAmountValue.map(value => value),
          savingsCurrencyCodeValue.map(value => value),
          savingsPercentageValue.map(value => value)
        )
    def totalRecommendationCountValue: Option[GenericString]
    def estimatedTotalMonthlySavingsAmountValue: Option[GenericString]
    def savingsCurrencyCodeValue: Option[GenericString]
    def savingsPercentageValue: Option[GenericString]
    def totalRecommendationCount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "totalRecommendationCount",
        totalRecommendationCountValue
      )
    def estimatedTotalMonthlySavingsAmount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedTotalMonthlySavingsAmount",
        estimatedTotalMonthlySavingsAmountValue
      )
    def savingsCurrencyCode: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("savingsCurrencyCode", savingsCurrencyCodeValue)
    def savingsPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("savingsPercentage", savingsPercentageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary
  ) extends io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly {
    override def totalRecommendationCountValue: Option[GenericString] = scala
      .Option(impl.totalRecommendationCount())
      .map(value => value: GenericString)
    override def estimatedTotalMonthlySavingsAmountValue
        : Option[GenericString] = scala
      .Option(impl.estimatedTotalMonthlySavingsAmount())
      .map(value => value: GenericString)
    override def savingsCurrencyCodeValue: Option[GenericString] = scala
      .Option(impl.savingsCurrencyCode())
      .map(value => value: GenericString)
    override def savingsPercentageValue: Option[GenericString] =
      scala.Option(impl.savingsPercentage()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary
  ): io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
