package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RightsizingRecommendation(
    accountId: Option[GenericString] = None,
    currentInstance: Option[
      io.github.vigoo.zioaws.costexplorer.model.CurrentInstance
    ] = None,
    rightsizingType: Option[
      io.github.vigoo.zioaws.costexplorer.model.RightsizingType
    ] = None,
    modifyRecommendationDetail: Option[
      io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail
    ] = None,
    terminateRecommendationDetail: Option[
      io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail
    ] = None,
    findingReasonCodes: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation = {
    import RightsizingRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(currentInstance.map(value => value.buildAwsValue()))(
        _.currentInstance
      )
      .optionallyWith(rightsizingType.map(value => value.unwrap))(
        _.rightsizingType
      )
      .optionallyWith(
        modifyRecommendationDetail.map(value => value.buildAwsValue())
      )(_.modifyRecommendationDetail)
      .optionallyWith(
        terminateRecommendationDetail.map(value => value.buildAwsValue())
      )(_.terminateRecommendationDetail)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation
      .wrap(buildAwsValue())
}
object RightsizingRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation =
      io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation(
        accountIdValue.map(value => value),
        currentInstanceValue.map(value => value.editable),
        rightsizingTypeValue.map(value => value),
        modifyRecommendationDetailValue.map(value => value.editable),
        terminateRecommendationDetailValue.map(value => value.editable),
        findingReasonCodesValue.map(value => value)
      )
    def accountIdValue: Option[GenericString]
    def currentInstanceValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly
    ]
    def rightsizingTypeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.RightsizingType]
    def modifyRecommendationDetailValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly
    ]
    def terminateRecommendationDetailValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly
    ]
    def findingReasonCodesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode]
    ]
    def accountId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def currentInstance: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly
    ] = AwsError.unwrapOptionField("currentInstance", currentInstanceValue)
    def rightsizingType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.RightsizingType
    ] = AwsError.unwrapOptionField("rightsizingType", rightsizingTypeValue)
    def modifyRecommendationDetail: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modifyRecommendationDetail",
      modifyRecommendationDetailValue
    )
    def terminateRecommendationDetail: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "terminateRecommendationDetail",
      terminateRecommendationDetailValue
    )
    def findingReasonCodes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode
    ]] =
      AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation
  ) extends io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly {
    override def accountIdValue: Option[GenericString] =
      scala.Option(impl.accountId()).map(value => value: GenericString)
    override def currentInstanceValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.ReadOnly
    ] = scala
      .Option(impl.currentInstance())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CurrentInstance.wrap(value)
      )
    override def rightsizingTypeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.RightsizingType] =
      scala
        .Option(impl.rightsizingType())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.RightsizingType.wrap(value)
        )
    override def modifyRecommendationDetailValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail.ReadOnly
    ] = scala
      .Option(impl.modifyRecommendationDetail())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ModifyRecommendationDetail
          .wrap(value)
      )
    override def terminateRecommendationDetailValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail.ReadOnly
    ] = scala
      .Option(impl.terminateRecommendationDetail())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.TerminateRecommendationDetail
          .wrap(value)
      )
    override def findingReasonCodesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode]
    ] = scala
      .Option(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.FindingReasonCode.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation
  ): io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendation.ReadOnly =
    new Wrapper(impl)
}
