package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceUtilization(
    ec2ResourceUtilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ResourceUtilization = {
    import ResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResourceUtilization
      .builder()
      .optionallyWith(
        ec2ResourceUtilization.map(value => value.buildAwsValue())
      )(_.ec2ResourceUtilization)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization
      .wrap(buildAwsValue())
}
object ResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization =
      io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization(
        ec2ResourceUtilizationValue.map(value => value.editable)
      )
    def ec2ResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly
    ]
    def ec2ResourceUtilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2ResourceUtilization",
      ec2ResourceUtilizationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ResourceUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly {
    override def ec2ResourceUtilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization.ReadOnly
    ] = scala
      .Option(impl.ec2ResourceUtilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.EC2ResourceUtilization
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ResourceUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.ResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
