package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceDetails(
    ec2ResourceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResourceDetails
      .builder()
      .optionallyWith(ec2ResourceDetails.map(value => value.buildAwsValue()))(
        _.ec2ResourceDetails
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ResourceDetails
      .wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.ResourceDetails =
      io.github.vigoo.zioaws.costexplorer.model
        .ResourceDetails(ec2ResourceDetailsValue.map(value => value.editable))
    def ec2ResourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly
    ]
    def ec2ResourceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("ec2ResourceDetails", ec2ResourceDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ResourceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly {
    override def ec2ResourceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly
    ] = scala
      .Option(impl.ec2ResourceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ResourceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.ResourceDetails.ReadOnly =
    new Wrapper(impl)
}
