package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  AttributeValue,
  AttributeType,
  ReservationGroupValue,
  ReservationGroupKey
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationUtilizationGroup(
    key: Option[ReservationGroupKey] = None,
    value: Option[ReservationGroupValue] = None,
    attributes: Option[Map[AttributeType, AttributeValue]] = None,
    utilization: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup = {
    import ReservationUtilizationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(utilization.map(value => value.buildAwsValue()))(
        _.utilization
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup
      .wrap(buildAwsValue())
}
object ReservationUtilizationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup =
      io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup(
        keyValue.map(value => value),
        valueValue.map(value => value),
        attributesValue.map(value => value),
        utilizationValue.map(value => value.editable)
      )
    def keyValue: Option[ReservationGroupKey]
    def valueValue: Option[ReservationGroupValue]
    def attributesValue: Option[Map[AttributeType, AttributeValue]]
    def utilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ]
    def key: ZIO[Any, AwsError, ReservationGroupKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, AwsError, ReservationGroupValue] =
      AwsError.unwrapOptionField("value", valueValue)
    def attributes: ZIO[Any, AwsError, Map[AttributeType, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
    def utilization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = AwsError.unwrapOptionField("utilization", utilizationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly {
    override def keyValue: Option[ReservationGroupKey] =
      scala.Option(impl.key()).map(value => value: ReservationGroupKey)
    override def valueValue: Option[ReservationGroupValue] =
      scala.Option(impl.value()).map(value => value: ReservationGroupValue)
    override def attributesValue: Option[Map[AttributeType, AttributeValue]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttributeType) -> (value: AttributeValue)
            })
            .toMap
        )
    override def utilizationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = scala
      .Option(impl.utilization())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationUtilizationGroup.ReadOnly =
    new Wrapper(impl)
}
