package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait PaymentOption {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption
}
object PaymentOption {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.PaymentOption
  ): io.github.vigoo.zioaws.costexplorer.model.PaymentOption = value match {
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.NO_UPFRONT =>
      val r = NO_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.PARTIAL_UPFRONT =>
      val r = PARTIAL_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.ALL_UPFRONT =>
      val r = ALL_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.LIGHT_UTILIZATION =>
      val r = LIGHT_UTILIZATION
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.MEDIUM_UTILIZATION =>
      val r = MEDIUM_UTILIZATION
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.HEAVY_UTILIZATION =>
      val r = HEAVY_UTILIZATION
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_UPFRONT
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.NO_UPFRONT
  }
  case object PARTIAL_UPFRONT
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.PARTIAL_UPFRONT
  }
  case object ALL_UPFRONT
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.ALL_UPFRONT
  }
  case object LIGHT_UTILIZATION
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.LIGHT_UTILIZATION
  }
  case object MEDIUM_UTILIZATION
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.MEDIUM_UTILIZATION
  }
  case object HEAVY_UTILIZATION
      extends io.github.vigoo.zioaws.costexplorer.model.PaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.PaymentOption =
      software.amazon.awssdk.services.costexplorer.model.PaymentOption.HEAVY_UTILIZATION
  }
}
