package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansUtilizationRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    granularity: Option[io.github.vigoo.zioaws.costexplorer.model.Granularity] =
      None,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    sortBy: Option[io.github.vigoo.zioaws.costexplorer.model.SortDefinition] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest = {
    import GetSavingsPlansUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .optionallyWith(granularity.map(value => value.unwrap))(_.granularity)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest
      .wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansUtilizationRequest(
          timePeriodValue.editable,
          granularityValue.map(value => value),
          filterValue.map(value => value.editable),
          sortByValue.map(value => value.editable)
        )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def granularityValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Granularity]
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Granularity
    ] = AwsError.unwrapOptionField("granularity", granularityValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def sortBy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortByValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def granularityValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Granularity] = scala
      .Option(impl.granularity())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Granularity.wrap(value)
      )
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SortDefinition.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationRequest.ReadOnly =
    new Wrapper(impl)
}
