package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservationUtilizationResponse(
    utilizationsByTime: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime
    ],
    total: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
    ] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse = {
    import GetReservationUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse
      .builder()
      .utilizationsByTime(utilizationsByTime.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse
      .wrap(buildAwsValue())
}
object GetReservationUtilizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetReservationUtilizationResponse(
          utilizationsByTimeValue.map { item =>
            item.editable
          },
          totalValue.map(value => value.editable),
          nextPageTokenValue.map(value => value)
        )
    def utilizationsByTimeValue: List[
      io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly
    ]
    def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def utilizationsByTime: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly
    ]] = ZIO.succeed(utilizationsByTimeValue)
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly {
    override def utilizationsByTimeValue: List[
      io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.ReadOnly
    ] = impl
      .utilizationsByTime()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.UtilizationByTime.wrap(item)
      }
      .toList
    override def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly
    ] = scala
      .Option(impl.total())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
          .wrap(value)
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetReservationUtilizationResponse.ReadOnly =
    new Wrapper(impl)
}
