package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  MaxResults,
  NextPageToken,
  MetricName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservationCoverageRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    groupBy: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition]
    ] = None,
    granularity: Option[io.github.vigoo.zioaws.costexplorer.model.Granularity] =
      None,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    metrics: Option[Iterable[MetricName]] = None,
    nextPageToken: Option[NextPageToken] = None,
    sortBy: Option[io.github.vigoo.zioaws.costexplorer.model.SortDefinition] =
      None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest = {
    import GetReservationCoverageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .optionallyWith(
        groupBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupBy)
      .optionallyWith(granularity.map(value => value.unwrap))(_.granularity)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest
      .wrap(buildAwsValue())
}
object GetReservationCoverageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest(
        timePeriodValue.editable,
        groupByValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        granularityValue.map(value => value),
        filterValue.map(value => value.editable),
        metricsValue.map(value => value),
        nextPageTokenValue.map(value => value),
        sortByValue.map(value => value.editable),
        maxResultsValue.map(value => value)
      )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ]
    def granularityValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Granularity]
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def metricsValue: Option[List[MetricName]]
    def nextPageTokenValue: Option[NextPageToken]
    def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ]
    def maxResultsValue: Option[MaxResults]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def groupBy: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("groupBy", groupByValue)
    def granularity: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Granularity
    ] = AwsError.unwrapOptionField("granularity", granularityValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def metrics: ZIO[Any, AwsError, List[MetricName]] =
      AwsError.unwrapOptionField("metrics", metricsValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def sortBy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortByValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ] = scala
      .Option(impl.groupBy())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.wrap(item)
        }.toList
      )
    override def granularityValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Granularity] = scala
      .Option(impl.granularity())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Granularity.wrap(value)
      )
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def metricsValue: Option[List[MetricName]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          item: MetricName
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def sortByValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SortDefinition.wrap(value)
      )
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageRequest.ReadOnly =
    new Wrapper(impl)
}
