package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  PageSize
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDimensionValuesResponse(
    dimensionValues: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
    ],
    returnSize: PageSize,
    totalSize: PageSize,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse = {
    import GetDimensionValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse
      .builder()
      .dimensionValues(dimensionValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .returnSize(returnSize: Integer)
      .totalSize(totalSize: Integer)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse
      .wrap(buildAwsValue())
}
object GetDimensionValuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse(
        dimensionValuesValue.map { item =>
          item.editable
        },
        returnSizeValue,
        totalSizeValue,
        nextPageTokenValue.map(value => value)
      )
    def dimensionValuesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ]
    def returnSizeValue: PageSize
    def totalSizeValue: PageSize
    def nextPageTokenValue: Option[NextPageToken]
    def dimensionValues: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ]] = ZIO.succeed(dimensionValuesValue)
    def returnSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(totalSizeValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly {
    override def dimensionValuesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes.ReadOnly
    ] = impl
      .dimensionValues()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.DimensionValuesWithAttributes
          .wrap(item)
      }
      .toList
    override def returnSizeValue: PageSize = impl.returnSize(): PageSize
    override def totalSizeValue: PageSize = impl.totalSize(): PageSize
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetDimensionValuesResponse.ReadOnly =
    new Wrapper(impl)
}
