package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomalySubscriptionsResponse(
    anomalySubscriptions: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription
    ],
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse = {
    import GetAnomalySubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse
      .builder()
      .anomalySubscriptions(anomalySubscriptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse
      .wrap(buildAwsValue())
}
object GetAnomalySubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse(
        anomalySubscriptionsValue.map { item =>
          item.editable
        },
        nextPageTokenValue.map(value => value)
      )
    def anomalySubscriptionsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def anomalySubscriptions: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly
    ]] = ZIO.succeed(anomalySubscriptionsValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly {
    override def anomalySubscriptionsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly
    ] = impl
      .anomalySubscriptions()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.wrap(item)
      }
      .toList
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
