package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomaliesResponse(
    anomalies: Iterable[io.github.vigoo.zioaws.costexplorer.model.Anomaly],
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse = {
    import GetAnomaliesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse
      .builder()
      .anomalies(anomalies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse
      .wrap(buildAwsValue())
}
object GetAnomaliesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse(
        anomaliesValue.map { item =>
          item.editable
        },
        nextPageTokenValue.map(value => value)
      )
    def anomaliesValue
        : List[io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly]
    def nextPageTokenValue: Option[NextPageToken]
    def anomalies: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly
    ]] = ZIO.succeed(anomaliesValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly {
    override def anomaliesValue
        : List[io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly] =
      impl
        .anomalies()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Anomaly.wrap(item)
        }
        .toList
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomaliesResponse.ReadOnly =
    new Wrapper(impl)
}
