package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2Specification(
    offeringClass: Option[
      io.github.vigoo.zioaws.costexplorer.model.OfferingClass
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.EC2Specification = {
    import EC2Specification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2Specification
      .builder()
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.EC2Specification
      .wrap(buildAwsValue())
}
object EC2Specification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.EC2Specification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.EC2Specification =
      io.github.vigoo.zioaws.costexplorer.model
        .EC2Specification(offeringClassValue.map(value => value))
    def offeringClassValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.OfferingClass]
    def offeringClass: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.OfferingClass
    ] = AwsError.unwrapOptionField("offeringClass", offeringClassValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2Specification
  ) extends io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly {
    override def offeringClassValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.OfferingClass] =
      scala
        .Option(impl.offeringClass())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.OfferingClass.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2Specification
  ): io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly =
    new Wrapper(impl)
}
