package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2ResourceDetails(
    hourlyOnDemandRate: Option[GenericString] = None,
    instanceType: Option[GenericString] = None,
    platform: Option[GenericString] = None,
    region: Option[GenericString] = None,
    sku: Option[GenericString] = None,
    memory: Option[GenericString] = None,
    networkPerformance: Option[GenericString] = None,
    storage: Option[GenericString] = None,
    vcpu: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails = {
    import EC2ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails
      .builder()
      .optionallyWith(hourlyOnDemandRate.map(value => value: java.lang.String))(
        _.hourlyOnDemandRate
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(sku.map(value => value: java.lang.String))(_.sku)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(networkPerformance.map(value => value: java.lang.String))(
        _.networkPerformance
      )
      .optionallyWith(storage.map(value => value: java.lang.String))(_.storage)
      .optionallyWith(vcpu.map(value => value: java.lang.String))(_.vcpu)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails
      .wrap(buildAwsValue())
}
object EC2ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails =
      io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails(
        hourlyOnDemandRateValue.map(value => value),
        instanceTypeValue.map(value => value),
        platformValue.map(value => value),
        regionValue.map(value => value),
        skuValue.map(value => value),
        memoryValue.map(value => value),
        networkPerformanceValue.map(value => value),
        storageValue.map(value => value),
        vcpuValue.map(value => value)
      )
    def hourlyOnDemandRateValue: Option[GenericString]
    def instanceTypeValue: Option[GenericString]
    def platformValue: Option[GenericString]
    def regionValue: Option[GenericString]
    def skuValue: Option[GenericString]
    def memoryValue: Option[GenericString]
    def networkPerformanceValue: Option[GenericString]
    def storageValue: Option[GenericString]
    def vcpuValue: Option[GenericString]
    def hourlyOnDemandRate: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("hourlyOnDemandRate", hourlyOnDemandRateValue)
    def instanceType: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def platform: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("platform", platformValue)
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def sku: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("sku", skuValue)
    def memory: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("memory", memoryValue)
    def networkPerformance: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("networkPerformance", networkPerformanceValue)
    def storage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("storage", storageValue)
    def vcpu: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("vcpu", vcpuValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly {
    override def hourlyOnDemandRateValue: Option[GenericString] =
      scala.Option(impl.hourlyOnDemandRate()).map(value => value: GenericString)
    override def instanceTypeValue: Option[GenericString] =
      scala.Option(impl.instanceType()).map(value => value: GenericString)
    override def platformValue: Option[GenericString] =
      scala.Option(impl.platform()).map(value => value: GenericString)
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def skuValue: Option[GenericString] =
      scala.Option(impl.sku()).map(value => value: GenericString)
    override def memoryValue: Option[GenericString] =
      scala.Option(impl.memory()).map(value => value: GenericString)
    override def networkPerformanceValue: Option[GenericString] =
      scala.Option(impl.networkPerformance()).map(value => value: GenericString)
    override def storageValue: Option[GenericString] =
      scala.Option(impl.storage()).map(value => value: GenericString)
    override def vcpuValue: Option[GenericString] =
      scala.Option(impl.vcpu()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails
  ): io.github.vigoo.zioaws.costexplorer.model.EC2ResourceDetails.ReadOnly =
    new Wrapper(impl)
}
