package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EBSResourceUtilization(
    ebsReadOpsPerSecond: Option[GenericString] = None,
    ebsWriteOpsPerSecond: Option[GenericString] = None,
    ebsReadBytesPerSecond: Option[GenericString] = None,
    ebsWriteBytesPerSecond: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization = {
    import EBSResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization
      .builder()
      .optionallyWith(
        ebsReadOpsPerSecond.map(value => value: java.lang.String)
      )(_.ebsReadOpsPerSecond)
      .optionallyWith(
        ebsWriteOpsPerSecond.map(value => value: java.lang.String)
      )(_.ebsWriteOpsPerSecond)
      .optionallyWith(
        ebsReadBytesPerSecond.map(value => value: java.lang.String)
      )(_.ebsReadBytesPerSecond)
      .optionallyWith(
        ebsWriteBytesPerSecond.map(value => value: java.lang.String)
      )(_.ebsWriteBytesPerSecond)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization
      .wrap(buildAwsValue())
}
object EBSResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization =
      io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization(
        ebsReadOpsPerSecondValue.map(value => value),
        ebsWriteOpsPerSecondValue.map(value => value),
        ebsReadBytesPerSecondValue.map(value => value),
        ebsWriteBytesPerSecondValue.map(value => value)
      )
    def ebsReadOpsPerSecondValue: Option[GenericString]
    def ebsWriteOpsPerSecondValue: Option[GenericString]
    def ebsReadBytesPerSecondValue: Option[GenericString]
    def ebsWriteBytesPerSecondValue: Option[GenericString]
    def ebsReadOpsPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("ebsReadOpsPerSecond", ebsReadOpsPerSecondValue)
    def ebsWriteOpsPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("ebsWriteOpsPerSecond", ebsWriteOpsPerSecondValue)
    def ebsReadBytesPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("ebsReadBytesPerSecond", ebsReadBytesPerSecondValue)
    def ebsWriteBytesPerSecond: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("ebsWriteBytesPerSecond", ebsWriteBytesPerSecondValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly {
    override def ebsReadOpsPerSecondValue: Option[GenericString] = scala
      .Option(impl.ebsReadOpsPerSecond())
      .map(value => value: GenericString)
    override def ebsWriteOpsPerSecondValue: Option[GenericString] = scala
      .Option(impl.ebsWriteOpsPerSecond())
      .map(value => value: GenericString)
    override def ebsReadBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.ebsReadBytesPerSecond())
      .map(value => value: GenericString)
    override def ebsWriteBytesPerSecondValue: Option[GenericString] = scala
      .Option(impl.ebsWriteBytesPerSecond())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.EBSResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
