package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CostCategoryValue,
  CostCategoryName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCostCategoryDefinitionRequest(
    name: CostCategoryName,
    ruleVersion: io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion,
    rules: Iterable[io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule],
    defaultValue: Option[CostCategoryValue] = None,
    splitChargeRules: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest = {
    import CreateCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest
      .builder()
      .name(name: java.lang.String)
      .ruleVersion(ruleVersion.unwrap)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(
        splitChargeRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.splitChargeRules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .CreateCostCategoryDefinitionRequest(
          nameValue,
          ruleVersionValue,
          rulesValue.map { item =>
            item.editable
          },
          defaultValueValue.map(value => value),
          splitChargeRulesValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def nameValue: CostCategoryName
    def ruleVersionValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
    def rulesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ]
    def defaultValueValue: Option[CostCategoryValue]
    def splitChargeRulesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]]
    def name: ZIO[Any, Nothing, CostCategoryName] = ZIO.succeed(nameValue)
    def ruleVersion: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
    ] = ZIO.succeed(ruleVersionValue)
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
    def defaultValue: ZIO[Any, AwsError, CostCategoryValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValueValue)
    def splitChargeRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]] = AwsError.unwrapOptionField("splitChargeRules", splitChargeRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest.ReadOnly {
    override def nameValue: CostCategoryName = impl.name(): CostCategoryName
    override def ruleVersionValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
        .wrap(impl.ruleVersion())
    override def rulesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ] = impl
      .rules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.wrap(item)
      }
      .toList
    override def defaultValueValue: Option[CostCategoryValue] =
      scala.Option(impl.defaultValue()).map(value => value: CostCategoryValue)
    override def splitChargeRulesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]] = scala
      .Option(impl.splitChargeRules())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest
  ): io.github.vigoo.zioaws.costexplorer.model.CreateCostCategoryDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
