package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAnomalySubscriptionResponse(
    subscriptionArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse = {
    import CreateAnomalySubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse
      .builder()
      .subscriptionArn(subscriptionArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse
      .wrap(buildAwsValue())
}
object CreateAnomalySubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .CreateAnomalySubscriptionResponse(subscriptionArnValue)
    def subscriptionArnValue: GenericString
    def subscriptionArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(subscriptionArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly {
    override def subscriptionArnValue: GenericString =
      impl.subscriptionArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse
  ): io.github.vigoo.zioaws.costexplorer.model.CreateAnomalySubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
