package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CoverageHoursPercentage,
  TotalRunningHours,
  ReservedHours,
  OnDemandHours
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoverageHours(
    onDemandHours: Option[OnDemandHours] = None,
    reservedHours: Option[ReservedHours] = None,
    totalRunningHours: Option[TotalRunningHours] = None,
    coverageHoursPercentage: Option[CoverageHoursPercentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CoverageHours = {
    import CoverageHours.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageHours
      .builder()
      .optionallyWith(onDemandHours.map(value => value: java.lang.String))(
        _.onDemandHours
      )
      .optionallyWith(reservedHours.map(value => value: java.lang.String))(
        _.reservedHours
      )
      .optionallyWith(totalRunningHours.map(value => value: java.lang.String))(
        _.totalRunningHours
      )
      .optionallyWith(
        coverageHoursPercentage.map(value => value: java.lang.String)
      )(_.coverageHoursPercentage)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CoverageHours
      .wrap(buildAwsValue())
}
object CoverageHours {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CoverageHours
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CoverageHours =
      io.github.vigoo.zioaws.costexplorer.model.CoverageHours(
        onDemandHoursValue.map(value => value),
        reservedHoursValue.map(value => value),
        totalRunningHoursValue.map(value => value),
        coverageHoursPercentageValue.map(value => value)
      )
    def onDemandHoursValue: Option[OnDemandHours]
    def reservedHoursValue: Option[ReservedHours]
    def totalRunningHoursValue: Option[TotalRunningHours]
    def coverageHoursPercentageValue: Option[CoverageHoursPercentage]
    def onDemandHours: ZIO[Any, AwsError, OnDemandHours] =
      AwsError.unwrapOptionField("onDemandHours", onDemandHoursValue)
    def reservedHours: ZIO[Any, AwsError, ReservedHours] =
      AwsError.unwrapOptionField("reservedHours", reservedHoursValue)
    def totalRunningHours: ZIO[Any, AwsError, TotalRunningHours] =
      AwsError.unwrapOptionField("totalRunningHours", totalRunningHoursValue)
    def coverageHoursPercentage: ZIO[Any, AwsError, CoverageHoursPercentage] =
      AwsError.unwrapOptionField(
        "coverageHoursPercentage",
        coverageHoursPercentageValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageHours
  ) extends io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly {
    override def onDemandHoursValue: Option[OnDemandHours] =
      scala.Option(impl.onDemandHours()).map(value => value: OnDemandHours)
    override def reservedHoursValue: Option[ReservedHours] =
      scala.Option(impl.reservedHours()).map(value => value: ReservedHours)
    override def totalRunningHoursValue: Option[TotalRunningHours] = scala
      .Option(impl.totalRunningHours())
      .map(value => value: TotalRunningHours)
    override def coverageHoursPercentageValue: Option[CoverageHoursPercentage] =
      scala
        .Option(impl.coverageHoursPercentage())
        .map(value => value: CoverageHoursPercentage)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageHours
  ): io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly =
    new Wrapper(impl)
}
