package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Coverage(
    coverageHours: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageHours
    ] = None,
    coverageNormalizedUnits: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits
    ] = None,
    coverageCost: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageCost
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Coverage = {
    import Coverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Coverage
      .builder()
      .optionallyWith(coverageHours.map(value => value.buildAwsValue()))(
        _.coverageHours
      )
      .optionallyWith(
        coverageNormalizedUnits.map(value => value.buildAwsValue())
      )(_.coverageNormalizedUnits)
      .optionallyWith(coverageCost.map(value => value.buildAwsValue()))(
        _.coverageCost
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Coverage.wrap(buildAwsValue())
}
object Coverage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Coverage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Coverage =
      io.github.vigoo.zioaws.costexplorer.model.Coverage(
        coverageHoursValue.map(value => value.editable),
        coverageNormalizedUnitsValue.map(value => value.editable),
        coverageCostValue.map(value => value.editable)
      )
    def coverageHoursValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly
    ]
    def coverageNormalizedUnitsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly
    ]
    def coverageCostValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly
    ]
    def coverageHours: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly
    ] = AwsError.unwrapOptionField("coverageHours", coverageHoursValue)
    def coverageNormalizedUnits: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly
    ] = AwsError.unwrapOptionField(
      "coverageNormalizedUnits",
      coverageNormalizedUnitsValue
    )
    def coverageCost: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly
    ] = AwsError.unwrapOptionField("coverageCost", coverageCostValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Coverage
  ) extends io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly {
    override def coverageHoursValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageHours.ReadOnly
    ] = scala
      .Option(impl.coverageHours())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CoverageHours.wrap(value)
      )
    override def coverageNormalizedUnitsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits.ReadOnly
    ] = scala
      .Option(impl.coverageNormalizedUnits())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CoverageNormalizedUnits
          .wrap(value)
      )
    override def coverageCostValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CoverageCost.ReadOnly
    ] = scala
      .Option(impl.coverageCost())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CoverageCost.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Coverage
  ): io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly = new Wrapper(
    impl
  )
}
