package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait CostCategoryRuleType {
  def unwrap
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType
}
object CostCategoryRuleType {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType =
    value match {
      case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.REGULAR =>
        val r = REGULAR
        r
      case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.INHERITED_VALUE =>
        val r = INHERITED_VALUE
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType =
      software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGULAR
      extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType =
      software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.REGULAR
  }
  case object INHERITED_VALUE
      extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleType {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType =
      software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType.INHERITED_VALUE
  }
}
