package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CostCategoryValue,
  CostCategoryName,
  ZonedDateTime,
  Arn
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategory(
    costCategoryArn: Arn,
    effectiveStart: ZonedDateTime,
    effectiveEnd: Option[ZonedDateTime] = None,
    name: CostCategoryName,
    ruleVersion: io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion,
    rules: Iterable[io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule],
    splitChargeRules: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule
    ]] = None,
    processingStatus: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus
    ]] = None,
    defaultValue: Option[CostCategoryValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategory = {
    import CostCategory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategory
      .builder()
      .costCategoryArn(costCategoryArn: java.lang.String)
      .effectiveStart(effectiveStart: java.lang.String)
      .optionallyWith(effectiveEnd.map(value => value: java.lang.String))(
        _.effectiveEnd
      )
      .name(name: java.lang.String)
      .ruleVersion(ruleVersion.unwrap)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        splitChargeRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.splitChargeRules)
      .optionallyWith(
        processingStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingStatus)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategory.wrap(buildAwsValue())
}
object CostCategory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CostCategory =
      io.github.vigoo.zioaws.costexplorer.model.CostCategory(
        costCategoryArnValue,
        effectiveStartValue,
        effectiveEndValue.map(value => value),
        nameValue,
        ruleVersionValue,
        rulesValue.map { item =>
          item.editable
        },
        splitChargeRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        processingStatusValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        defaultValueValue.map(value => value)
      )
    def costCategoryArnValue: Arn
    def effectiveStartValue: ZonedDateTime
    def effectiveEndValue: Option[ZonedDateTime]
    def nameValue: CostCategoryName
    def ruleVersionValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
    def rulesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ]
    def splitChargeRulesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]]
    def processingStatusValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]]
    def defaultValueValue: Option[CostCategoryValue]
    def costCategoryArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(costCategoryArnValue)
    def effectiveStart: ZIO[Any, Nothing, ZonedDateTime] =
      ZIO.succeed(effectiveStartValue)
    def effectiveEnd: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
    def name: ZIO[Any, Nothing, CostCategoryName] = ZIO.succeed(nameValue)
    def ruleVersion: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
    ] = ZIO.succeed(ruleVersionValue)
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
    def splitChargeRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]] = AwsError.unwrapOptionField("splitChargeRules", splitChargeRulesValue)
    def processingStatus: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("processingStatus", processingStatusValue)
    def defaultValue: ZIO[Any, AwsError, CostCategoryValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategory
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly {
    override def costCategoryArnValue: Arn = impl.costCategoryArn(): Arn
    override def effectiveStartValue: ZonedDateTime =
      impl.effectiveStart(): ZonedDateTime
    override def effectiveEndValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveEnd()).map(value => value: ZonedDateTime)
    override def nameValue: CostCategoryName = impl.name(): CostCategoryName
    override def ruleVersionValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion
        .wrap(impl.ruleVersion())
    override def rulesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.ReadOnly
    ] = impl
      .rules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryRule.wrap(item)
      }
      .toList
    override def splitChargeRulesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly
    ]] = scala
      .Option(impl.splitChargeRules())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule
            .wrap(item)
        }.toList
      )
    override def processingStatusValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly
    ]] = scala
      .Option(impl.processingStatus())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus
            .wrap(item)
        }.toList
      )
    override def defaultValueValue: Option[CostCategoryValue] =
      scala.Option(impl.defaultValue()).map(value => value: CostCategoryValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategory
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly =
    new Wrapper(impl)
}
