package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetUsageForecastResponse(
    total: Option[io.github.vigoo.zioaws.costexplorer.model.MetricValue] = None,
    forecastResultsByTime: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.ForecastResult]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse = {
    import GetUsageForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse
      .builder()
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .optionallyWith(
        forecastResultsByTime.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.forecastResultsByTime)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse
      .wrap(buildAwsValue())
}
object GetUsageForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse(
        totalValue.map(value => value.editable),
        forecastResultsByTimeValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def totalValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly]
    def forecastResultsByTimeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly]
    ]
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
    def forecastResultsByTime: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "forecastResultsByTime",
      forecastResultsByTimeValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly {
    override def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly
    ] = scala
      .Option(impl.total())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.MetricValue.wrap(value)
      )
    override def forecastResultsByTimeValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.ForecastResult.ReadOnly]
    ] = scala
      .Option(impl.forecastResultsByTime())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ForecastResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetUsageForecastResponse.ReadOnly =
    new Wrapper(impl)
}
