package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansCoverageResponse(
    savingsPlansCoverages: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage
    ],
    nextToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse = {
    import GetSavingsPlansCoverageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse
      .builder()
      .savingsPlansCoverages(savingsPlansCoverages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse
      .wrap(buildAwsValue())
}
object GetSavingsPlansCoverageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse(
        savingsPlansCoveragesValue.map { item =>
          item.editable
        },
        nextTokenValue.map(value => value)
      )
    def savingsPlansCoveragesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
    ]
    def nextTokenValue: Option[NextPageToken]
    def savingsPlansCoverages: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
    ]] = ZIO.succeed(savingsPlansCoveragesValue)
    def nextToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse.ReadOnly {
    override def savingsPlansCoveragesValue: List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly
    ] = impl
      .savingsPlansCoverages()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage
          .wrap(item)
      }
      .toList
    override def nextTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansCoverageResponse.ReadOnly =
    new Wrapper(impl)
}
