package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservationCoverageResponse(
    coveragesByTime: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CoverageByTime
    ],
    total: Option[io.github.vigoo.zioaws.costexplorer.model.Coverage] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse = {
    import GetReservationCoverageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse
      .builder()
      .coveragesByTime(coveragesByTime.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse
      .wrap(buildAwsValue())
}
object GetReservationCoverageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse(
        coveragesByTimeValue.map { item =>
          item.editable
        },
        totalValue.map(value => value.editable),
        nextPageTokenValue.map(value => value)
      )
    def coveragesByTimeValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly
    ]
    def totalValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly]
    def nextPageTokenValue: Option[NextPageToken]
    def coveragesByTime: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly
    ]] = ZIO.succeed(coveragesByTimeValue)
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly {
    override def coveragesByTimeValue: List[
      io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly
    ] = impl
      .coveragesByTime()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.wrap(item)
      }
      .toList
    override def totalValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly] =
      scala
        .Option(impl.total())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.Coverage.wrap(value)
        )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetReservationCoverageResponse.ReadOnly =
    new Wrapper(impl)
}
