package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SubscriberStatus { def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus }
object SubscriberStatus {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus): SubscriberStatus = value match {
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.CONFIRMED =>
      val r = CONFIRMED
      r
    case software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.DECLINED =>
      val r = DECLINED
      r
  }
  case object unknownToSdkVersion extends SubscriberStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus = software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION }
  case object CONFIRMED extends SubscriberStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus = software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.CONFIRMED }
  case object DECLINED extends SubscriberStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.SubscriberStatus = software.amazon.awssdk.services.costexplorer.model.SubscriberStatus.DECLINED }
}