package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RightsizingRecommendationConfiguration(recommendationTarget: RecommendationTarget, benefitsConsidered: primitives.GenericBoolean) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration = {
    import RightsizingRecommendationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration.builder().recommendationTarget(recommendationTarget.unwrap).benefitsConsidered(benefitsConsidered: java.lang.Boolean).build()
  }
  def asReadOnly: RightsizingRecommendationConfiguration.ReadOnly = RightsizingRecommendationConfiguration.wrap(buildAwsValue())
}
object RightsizingRecommendationConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RightsizingRecommendationConfiguration = RightsizingRecommendationConfiguration(recommendationTargetValue, benefitsConsideredValue)
    def recommendationTargetValue: RecommendationTarget
    def benefitsConsideredValue: primitives.GenericBoolean
    def recommendationTarget: ZIO[Any, Nothing, RecommendationTarget] = ZIO.succeed(recommendationTargetValue)
    def benefitsConsidered: ZIO[Any, Nothing, primitives.GenericBoolean] = ZIO.succeed(benefitsConsideredValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration) extends RightsizingRecommendationConfiguration.ReadOnly {
    override def recommendationTargetValue: RecommendationTarget = RecommendationTarget.wrap(impl.recommendationTarget())
    override def benefitsConsideredValue: primitives.GenericBoolean = impl.benefitsConsidered(): primitives.GenericBoolean
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration): ReadOnly = new Wrapper(impl)
}