package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResultByTime(timePeriod: scala.Option[DateInterval] = None, total: scala.Option[Map[primitives.MetricName, MetricValue]] = None, groups: scala.Option[Iterable[Group]] = None, estimated: scala.Option[primitives.Estimated] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ResultByTime = {
    import ResultByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResultByTime.builder().optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(total.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.total).optionallyWith(groups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groups).optionallyWith(estimated.map(value => value: java.lang.Boolean))(_.estimated).build()
  }
  def asReadOnly: ResultByTime.ReadOnly = ResultByTime.wrap(buildAwsValue())
}
object ResultByTime {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ResultByTime] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResultByTime = ResultByTime(timePeriodValue.map(value => value.editable), totalValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })), groupsValue.map(value => value.map { item => 
      item.editable
    }), estimatedValue.map(value => value))
    def timePeriodValue: scala.Option[DateInterval.ReadOnly]
    def totalValue: scala.Option[Map[primitives.MetricName, MetricValue.ReadOnly]]
    def groupsValue: scala.Option[List[Group.ReadOnly]]
    def estimatedValue: scala.Option[primitives.Estimated]
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DateInterval.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.MetricName, MetricValue.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
    def groups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Group.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groups", groupsValue)
    def estimated: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Estimated] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimated", estimatedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ResultByTime) extends ResultByTime.ReadOnly {
    override def timePeriodValue: scala.Option[DateInterval.ReadOnly] = scala.Option(impl.timePeriod()).map(value => DateInterval.wrap(value))
    override def totalValue: scala.Option[Map[primitives.MetricName, MetricValue.ReadOnly]] = scala.Option(impl.total()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.MetricName) -> MetricValue.wrap(value)
    }).toMap)
    override def groupsValue: scala.Option[List[Group.ReadOnly]] = scala.Option(impl.groups()).map(value => value.asScala.map { item => 
      Group.wrap(item)
    }.toList)
    override def estimatedValue: scala.Option[primitives.Estimated] = scala.Option(impl.estimated()).map(value => value: primitives.Estimated)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ResultByTime): ReadOnly = new Wrapper(impl)
}