package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ProvideAnomalyFeedbackResponse(anomalyId: primitives.GenericString) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse = {
    import ProvideAnomalyFeedbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse.builder().anomalyId(anomalyId: java.lang.String).build()
  }
  def asReadOnly: ProvideAnomalyFeedbackResponse.ReadOnly = ProvideAnomalyFeedbackResponse.wrap(buildAwsValue())
}
object ProvideAnomalyFeedbackResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ProvideAnomalyFeedbackResponse = ProvideAnomalyFeedbackResponse(anomalyIdValue)
    def anomalyIdValue: primitives.GenericString
    def anomalyId: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(anomalyIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse) extends ProvideAnomalyFeedbackResponse.ReadOnly { override def anomalyIdValue: primitives.GenericString = impl.anomalyId(): primitives.GenericString }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse): ReadOnly = new Wrapper(impl)
}