package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MetricValue(amount: scala.Option[primitives.MetricAmount] = None, unit: scala.Option[primitives.MetricUnit] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.MetricValue = {
    import MetricValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.MetricValue.builder().optionallyWith(amount.map(value => value: java.lang.String))(_.amount).optionallyWith(unit.map(value => value: java.lang.String))(_.unit).build()
  }
  def asReadOnly: MetricValue.ReadOnly = MetricValue.wrap(buildAwsValue())
}
object MetricValue {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.MetricValue] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MetricValue = MetricValue(amountValue.map(value => value), unitValue.map(value => value))
    def amountValue: scala.Option[primitives.MetricAmount]
    def unitValue: scala.Option[primitives.MetricUnit]
    def amount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MetricAmount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amount", amountValue)
    def unit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MetricUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.MetricValue) extends MetricValue.ReadOnly {
    override def amountValue: scala.Option[primitives.MetricAmount] = scala.Option(impl.amount()).map(value => value: primitives.MetricAmount)
    override def unitValue: scala.Option[primitives.MetricUnit] = scala.Option(impl.unit()).map(value => value: primitives.MetricUnit)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.MetricValue): ReadOnly = new Wrapper(impl)
}