package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LookbackPeriodInDays { def unwrap: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays }
object LookbackPeriodInDays {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays): LookbackPeriodInDays = value match {
    case software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.SEVEN_DAYS =>
      val r = SEVEN_DAYS
      r
    case software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.THIRTY_DAYS =>
      val r = THIRTY_DAYS
      r
    case software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.SIXTY_DAYS =>
      val r = SIXTY_DAYS
      r
  }
  case object unknownToSdkVersion extends LookbackPeriodInDays { override def unwrap: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays = software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.UNKNOWN_TO_SDK_VERSION }
  case object SEVEN_DAYS extends LookbackPeriodInDays { override def unwrap: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays = software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.SEVEN_DAYS }
  case object THIRTY_DAYS extends LookbackPeriodInDays { override def unwrap: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays = software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.THIRTY_DAYS }
  case object SIXTY_DAYS extends LookbackPeriodInDays { override def unwrap: software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays = software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays.SIXTY_DAYS }
}