package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetUsageForecastRequest(timePeriod: DateInterval, metric: Metric, granularity: Granularity, filter: scala.Option[Expression] = None, predictionIntervalLevel: scala.Option[primitives.PredictionIntervalLevel] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest = {
    import GetUsageForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest.builder().timePeriod(timePeriod.buildAwsValue()).metric(metric.unwrap).granularity(granularity.unwrap).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(predictionIntervalLevel.map(value => value: java.lang.Integer))(_.predictionIntervalLevel).build()
  }
  def asReadOnly: GetUsageForecastRequest.ReadOnly = GetUsageForecastRequest.wrap(buildAwsValue())
}
object GetUsageForecastRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetUsageForecastRequest = GetUsageForecastRequest(timePeriodValue.editable, metricValue, granularityValue, filterValue.map(value => value.editable), predictionIntervalLevelValue.map(value => value))
    def timePeriodValue: DateInterval.ReadOnly
    def metricValue: Metric
    def granularityValue: Granularity
    def filterValue: scala.Option[Expression.ReadOnly]
    def predictionIntervalLevelValue: scala.Option[primitives.PredictionIntervalLevel]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def metric: ZIO[Any, Nothing, Metric] = ZIO.succeed(metricValue)
    def granularity: ZIO[Any, Nothing, Granularity] = ZIO.succeed(granularityValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def predictionIntervalLevel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PredictionIntervalLevel] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("predictionIntervalLevel", predictionIntervalLevelValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest) extends GetUsageForecastRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def metricValue: Metric = Metric.wrap(impl.metric())
    override def granularityValue: Granularity = Granularity.wrap(impl.granularity())
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def predictionIntervalLevelValue: scala.Option[primitives.PredictionIntervalLevel] = scala.Option(impl.predictionIntervalLevel()).map(value => value: primitives.PredictionIntervalLevel)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest): ReadOnly = new Wrapper(impl)
}