package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSavingsPlansCoverageRequest(timePeriod: DateInterval, groupBy: scala.Option[Iterable[GroupDefinition]] = None, granularity: scala.Option[Granularity] = None, filter: scala.Option[Expression] = None, metrics: scala.Option[Iterable[primitives.MetricName]] = None, nextToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.MaxResults] = None, sortBy: scala.Option[SortDefinition] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest = {
    import GetSavingsPlansCoverageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest.builder().timePeriod(timePeriod.buildAwsValue()).optionallyWith(groupBy.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groupBy).optionallyWith(granularity.map(value => value.unwrap))(_.granularity).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(metrics.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.metrics).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy).build()
  }
  def asReadOnly: GetSavingsPlansCoverageRequest.ReadOnly = GetSavingsPlansCoverageRequest.wrap(buildAwsValue())
}
object GetSavingsPlansCoverageRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSavingsPlansCoverageRequest = GetSavingsPlansCoverageRequest(timePeriodValue.editable, groupByValue.map(value => value.map { item => 
      item.editable
    }), granularityValue.map(value => value), filterValue.map(value => value.editable), metricsValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value), sortByValue.map(value => value.editable))
    def timePeriodValue: DateInterval.ReadOnly
    def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]]
    def granularityValue: scala.Option[Granularity]
    def filterValue: scala.Option[Expression.ReadOnly]
    def metricsValue: scala.Option[List[primitives.MetricName]]
    def nextTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def sortByValue: scala.Option[SortDefinition.ReadOnly]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def groupBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GroupDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groupBy", groupByValue)
    def granularity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Granularity] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("granularity", granularityValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def metrics: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.MetricName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metrics", metricsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def sortBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SortDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortBy", sortByValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest) extends GetSavingsPlansCoverageRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]] = scala.Option(impl.groupBy()).map(value => value.asScala.map { item => 
      GroupDefinition.wrap(item)
    }.toList)
    override def granularityValue: scala.Option[Granularity] = scala.Option(impl.granularity()).map(value => Granularity.wrap(value))
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def metricsValue: scala.Option[List[primitives.MetricName]] = scala.Option(impl.metrics()).map(value => value.asScala.map { item => 
      item: primitives.MetricName
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def sortByValue: scala.Option[SortDefinition.ReadOnly] = scala.Option(impl.sortBy()).map(value => SortDefinition.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest): ReadOnly = new Wrapper(impl)
}