package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCostAndUsageWithResourcesRequest(timePeriod: DateInterval, granularity: Granularity, filter: Expression, metrics: scala.Option[Iterable[primitives.MetricName]] = None, groupBy: scala.Option[Iterable[GroupDefinition]] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest = {
    import GetCostAndUsageWithResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest.builder().timePeriod(timePeriod.buildAwsValue()).granularity(granularity.unwrap).filter(filter.buildAwsValue()).optionallyWith(metrics.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.metrics).optionallyWith(groupBy.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groupBy).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetCostAndUsageWithResourcesRequest.ReadOnly = GetCostAndUsageWithResourcesRequest.wrap(buildAwsValue())
}
object GetCostAndUsageWithResourcesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCostAndUsageWithResourcesRequest = GetCostAndUsageWithResourcesRequest(timePeriodValue.editable, granularityValue, filterValue.editable, metricsValue.map(value => value), groupByValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def timePeriodValue: DateInterval.ReadOnly
    def granularityValue: Granularity
    def filterValue: Expression.ReadOnly
    def metricsValue: scala.Option[List[primitives.MetricName]]
    def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[Any, Nothing, Granularity] = ZIO.succeed(granularityValue)
    def filter: ZIO[Any, Nothing, Expression.ReadOnly] = ZIO.succeed(filterValue)
    def metrics: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.MetricName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metrics", metricsValue)
    def groupBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GroupDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groupBy", groupByValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest) extends GetCostAndUsageWithResourcesRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def granularityValue: Granularity = Granularity.wrap(impl.granularity())
    override def filterValue: Expression.ReadOnly = Expression.wrap(impl.filter())
    override def metricsValue: scala.Option[List[primitives.MetricName]] = scala.Option(impl.metrics()).map(value => value.asScala.map { item => 
      item: primitives.MetricName
    }.toList)
    override def groupByValue: scala.Option[List[GroupDefinition.ReadOnly]] = scala.Option(impl.groupBy()).map(value => value.asScala.map { item => 
      GroupDefinition.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest): ReadOnly = new Wrapper(impl)
}