package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCostAndUsageResponse(nextPageToken: scala.Option[primitives.NextPageToken] = None, groupDefinitions: scala.Option[Iterable[GroupDefinition]] = None, resultsByTime: scala.Option[Iterable[ResultByTime]] = None, dimensionValueAttributes: scala.Option[Iterable[DimensionValuesWithAttributes]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse = {
    import GetCostAndUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse.builder().optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(groupDefinitions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groupDefinitions).optionallyWith(resultsByTime.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.resultsByTime).optionallyWith(dimensionValueAttributes.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dimensionValueAttributes).build()
  }
  def asReadOnly: GetCostAndUsageResponse.ReadOnly = GetCostAndUsageResponse.wrap(buildAwsValue())
}
object GetCostAndUsageResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCostAndUsageResponse = GetCostAndUsageResponse(nextPageTokenValue.map(value => value), groupDefinitionsValue.map(value => value.map { item => 
      item.editable
    }), resultsByTimeValue.map(value => value.map { item => 
      item.editable
    }), dimensionValueAttributesValue.map(value => value.map { item => 
      item.editable
    }))
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def groupDefinitionsValue: scala.Option[List[GroupDefinition.ReadOnly]]
    def resultsByTimeValue: scala.Option[List[ResultByTime.ReadOnly]]
    def dimensionValueAttributesValue: scala.Option[List[DimensionValuesWithAttributes.ReadOnly]]
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def groupDefinitions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GroupDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groupDefinitions", groupDefinitionsValue)
    def resultsByTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ResultByTime.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resultsByTime", resultsByTimeValue)
    def dimensionValueAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DimensionValuesWithAttributes.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensionValueAttributes", dimensionValueAttributesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse) extends GetCostAndUsageResponse.ReadOnly {
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def groupDefinitionsValue: scala.Option[List[GroupDefinition.ReadOnly]] = scala.Option(impl.groupDefinitions()).map(value => value.asScala.map { item => 
      GroupDefinition.wrap(item)
    }.toList)
    override def resultsByTimeValue: scala.Option[List[ResultByTime.ReadOnly]] = scala.Option(impl.resultsByTime()).map(value => value.asScala.map { item => 
      ResultByTime.wrap(item)
    }.toList)
    override def dimensionValueAttributesValue: scala.Option[List[DimensionValuesWithAttributes.ReadOnly]] = scala.Option(impl.dimensionValueAttributes()).map(value => value.asScala.map { item => 
      DimensionValuesWithAttributes.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse): ReadOnly = new Wrapper(impl)
}