package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait Dimension { def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension }
object Dimension {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.Dimension): Dimension = value match {
    case software.amazon.awssdk.services.costexplorer.model.Dimension.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.AZ =>
      val r = AZ
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.INSTANCE_TYPE =>
      val r = INSTANCE_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.LINKED_ACCOUNT =>
      val r = LINKED_ACCOUNT
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.LINKED_ACCOUNT_NAME =>
      val r = LINKED_ACCOUNT_NAME
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.OPERATION =>
      val r = OPERATION
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.PURCHASE_TYPE =>
      val r = PURCHASE_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.REGION =>
      val r = REGION
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SERVICE =>
      val r = SERVICE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SERVICE_CODE =>
      val r = SERVICE_CODE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.USAGE_TYPE =>
      val r = USAGE_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.USAGE_TYPE_GROUP =>
      val r = USAGE_TYPE_GROUP
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.RECORD_TYPE =>
      val r = RECORD_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.OPERATING_SYSTEM =>
      val r = OPERATING_SYSTEM
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.TENANCY =>
      val r = TENANCY
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SCOPE =>
      val r = SCOPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.PLATFORM =>
      val r = PLATFORM
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SUBSCRIPTION_ID =>
      val r = SUBSCRIPTION_ID
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.LEGAL_ENTITY_NAME =>
      val r = LEGAL_ENTITY_NAME
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.DEPLOYMENT_OPTION =>
      val r = DEPLOYMENT_OPTION
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.DATABASE_ENGINE =>
      val r = DATABASE_ENGINE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.CACHE_ENGINE =>
      val r = CACHE_ENGINE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.INSTANCE_TYPE_FAMILY =>
      val r = INSTANCE_TYPE_FAMILY
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.BILLING_ENTITY =>
      val r = BILLING_ENTITY
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.RESERVATION_ID =>
      val r = RESERVATION_ID
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.RESOURCE_ID =>
      val r = RESOURCE_ID
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.RIGHTSIZING_TYPE =>
      val r = RIGHTSIZING_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SAVINGS_PLANS_TYPE =>
      val r = SAVINGS_PLANS_TYPE
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.SAVINGS_PLAN_ARN =>
      val r = SAVINGS_PLAN_ARN
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.PAYMENT_OPTION =>
      val r = PAYMENT_OPTION
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.AGREEMENT_END_DATE_TIME_AFTER =>
      val r = AGREEMENT_END_DATE_TIME_AFTER
      r
    case software.amazon.awssdk.services.costexplorer.model.Dimension.AGREEMENT_END_DATE_TIME_BEFORE =>
      val r = AGREEMENT_END_DATE_TIME_BEFORE
      r
  }
  case object unknownToSdkVersion extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.UNKNOWN_TO_SDK_VERSION }
  case object AZ extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.AZ }
  case object INSTANCE_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.INSTANCE_TYPE }
  case object LINKED_ACCOUNT extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.LINKED_ACCOUNT }
  case object LINKED_ACCOUNT_NAME extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.LINKED_ACCOUNT_NAME }
  case object OPERATION extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.OPERATION }
  case object PURCHASE_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.PURCHASE_TYPE }
  case object REGION extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.REGION }
  case object SERVICE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SERVICE }
  case object SERVICE_CODE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SERVICE_CODE }
  case object USAGE_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.USAGE_TYPE }
  case object USAGE_TYPE_GROUP extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.USAGE_TYPE_GROUP }
  case object RECORD_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.RECORD_TYPE }
  case object OPERATING_SYSTEM extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.OPERATING_SYSTEM }
  case object TENANCY extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.TENANCY }
  case object SCOPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SCOPE }
  case object PLATFORM extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.PLATFORM }
  case object SUBSCRIPTION_ID extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SUBSCRIPTION_ID }
  case object LEGAL_ENTITY_NAME extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.LEGAL_ENTITY_NAME }
  case object DEPLOYMENT_OPTION extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.DEPLOYMENT_OPTION }
  case object DATABASE_ENGINE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.DATABASE_ENGINE }
  case object CACHE_ENGINE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.CACHE_ENGINE }
  case object INSTANCE_TYPE_FAMILY extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.INSTANCE_TYPE_FAMILY }
  case object BILLING_ENTITY extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.BILLING_ENTITY }
  case object RESERVATION_ID extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.RESERVATION_ID }
  case object RESOURCE_ID extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.RESOURCE_ID }
  case object RIGHTSIZING_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.RIGHTSIZING_TYPE }
  case object SAVINGS_PLANS_TYPE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SAVINGS_PLANS_TYPE }
  case object SAVINGS_PLAN_ARN extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.SAVINGS_PLAN_ARN }
  case object PAYMENT_OPTION extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.PAYMENT_OPTION }
  case object AGREEMENT_END_DATE_TIME_AFTER extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.AGREEMENT_END_DATE_TIME_AFTER }
  case object AGREEMENT_END_DATE_TIME_BEFORE extends Dimension { override def unwrap: software.amazon.awssdk.services.costexplorer.model.Dimension = software.amazon.awssdk.services.costexplorer.model.Dimension.AGREEMENT_END_DATE_TIME_BEFORE }
}