package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceSpecification(
    ec2Specification: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2Specification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ServiceSpecification = {
    import ServiceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ServiceSpecification
      .builder()
      .optionallyWith(ec2Specification.map(value => value.buildAwsValue()))(
        _.ec2Specification
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification
      .wrap(buildAwsValue())
}
object ServiceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ServiceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification =
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification(
        ec2SpecificationValue.map(value => value.editable)
      )
    def ec2SpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly
    ]
    def ec2Specification: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly
    ] = AwsError.unwrapOptionField("ec2Specification", ec2SpecificationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ServiceSpecification
  ) extends io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly {
    override def ec2SpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.EC2Specification.ReadOnly
    ] = scala
      .Option(impl.ec2Specification())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.EC2Specification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ServiceSpecification
  ): io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly =
    new Wrapper(impl)
}
