package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationPurchaseRecommendationSummary(
    totalEstimatedMonthlySavingsAmount: Option[GenericString] = None,
    totalEstimatedMonthlySavingsPercentage: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary = {
    import ReservationPurchaseRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary
      .builder()
      .optionallyWith(
        totalEstimatedMonthlySavingsAmount.map(value => value: java.lang.String)
      )(_.totalEstimatedMonthlySavingsAmount)
      .optionallyWith(
        totalEstimatedMonthlySavingsPercentage.map(value =>
          value: java.lang.String
        )
      )(_.totalEstimatedMonthlySavingsPercentage)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary
      .wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary =
      io.github.vigoo.zioaws.costexplorer.model
        .ReservationPurchaseRecommendationSummary(
          totalEstimatedMonthlySavingsAmountValue.map(value => value),
          totalEstimatedMonthlySavingsPercentageValue.map(value => value),
          currencyCodeValue.map(value => value)
        )
    def totalEstimatedMonthlySavingsAmountValue: Option[GenericString]
    def totalEstimatedMonthlySavingsPercentageValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def totalEstimatedMonthlySavingsAmount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "totalEstimatedMonthlySavingsAmount",
        totalEstimatedMonthlySavingsAmountValue
      )
    def totalEstimatedMonthlySavingsPercentage
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "totalEstimatedMonthlySavingsPercentage",
      totalEstimatedMonthlySavingsPercentageValue
    )
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly {
    override def totalEstimatedMonthlySavingsAmountValue
        : Option[GenericString] = scala
      .Option(impl.totalEstimatedMonthlySavingsAmount())
      .map(value => value: GenericString)
    override def totalEstimatedMonthlySavingsPercentageValue
        : Option[GenericString] = scala
      .Option(impl.totalEstimatedMonthlySavingsPercentage())
      .map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
