package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationTarget {
  def unwrap
      : software.amazon.awssdk.services.costexplorer.model.RecommendationTarget
}
object RecommendationTarget {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.RecommendationTarget
  ): io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget =
    value match {
      case software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.SAME_INSTANCE_FAMILY =>
        val r = SAME_INSTANCE_FAMILY
        r
      case software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.CROSS_INSTANCE_FAMILY =>
        val r = CROSS_INSTANCE_FAMILY
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RecommendationTarget =
      software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.UNKNOWN_TO_SDK_VERSION
  }
  case object SAME_INSTANCE_FAMILY
      extends io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RecommendationTarget =
      software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.SAME_INSTANCE_FAMILY
  }
  case object CROSS_INSTANCE_FAMILY
      extends io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.RecommendationTarget =
      software.amazon.awssdk.services.costexplorer.model.RecommendationTarget.CROSS_INSTANCE_FAMILY
  }
}
