package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait Granularity {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.Granularity
}
object Granularity {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.Granularity
  ): io.github.vigoo.zioaws.costexplorer.model.Granularity = value match {
    case software.amazon.awssdk.services.costexplorer.model.Granularity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.MONTHLY =>
      val r = MONTHLY
      r
    case software.amazon.awssdk.services.costexplorer.model.Granularity.HOURLY =>
      val r = HOURLY
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.Granularity {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Granularity =
      software.amazon.awssdk.services.costexplorer.model.Granularity.UNKNOWN_TO_SDK_VERSION
  }
  case object DAILY
      extends io.github.vigoo.zioaws.costexplorer.model.Granularity {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Granularity =
      software.amazon.awssdk.services.costexplorer.model.Granularity.DAILY
  }
  case object MONTHLY
      extends io.github.vigoo.zioaws.costexplorer.model.Granularity {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Granularity =
      software.amazon.awssdk.services.costexplorer.model.Granularity.MONTHLY
  }
  case object HOURLY
      extends io.github.vigoo.zioaws.costexplorer.model.Granularity {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Granularity =
      software.amazon.awssdk.services.costexplorer.model.Granularity.HOURLY
  }
}
