package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansPurchaseRecommendationSummary(estimatedROI: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None, estimatedTotalCost: scala.Option[primitives.GenericString] = None, currentOnDemandSpend: scala.Option[primitives.GenericString] = None, estimatedSavingsAmount: scala.Option[primitives.GenericString] = None, totalRecommendationCount: scala.Option[primitives.GenericString] = None, dailyCommitmentToPurchase: scala.Option[primitives.GenericString] = None, hourlyCommitmentToPurchase: scala.Option[primitives.GenericString] = None, estimatedSavingsPercentage: scala.Option[primitives.GenericString] = None, estimatedMonthlySavingsAmount: scala.Option[primitives.GenericString] = None, estimatedOnDemandCostWithCurrentCommitment: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary = {
    import SavingsPlansPurchaseRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.builder().optionallyWith(estimatedROI.map(value => value: java.lang.String))(_.estimatedROI).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).optionallyWith(estimatedTotalCost.map(value => value: java.lang.String))(_.estimatedTotalCost).optionallyWith(currentOnDemandSpend.map(value => value: java.lang.String))(_.currentOnDemandSpend).optionallyWith(estimatedSavingsAmount.map(value => value: java.lang.String))(_.estimatedSavingsAmount).optionallyWith(totalRecommendationCount.map(value => value: java.lang.String))(_.totalRecommendationCount).optionallyWith(dailyCommitmentToPurchase.map(value => value: java.lang.String))(_.dailyCommitmentToPurchase).optionallyWith(hourlyCommitmentToPurchase.map(value => value: java.lang.String))(_.hourlyCommitmentToPurchase).optionallyWith(estimatedSavingsPercentage.map(value => value: java.lang.String))(_.estimatedSavingsPercentage).optionallyWith(estimatedMonthlySavingsAmount.map(value => value: java.lang.String))(_.estimatedMonthlySavingsAmount).optionallyWith(estimatedOnDemandCostWithCurrentCommitment.map(value => value: java.lang.String))(_.estimatedOnDemandCostWithCurrentCommitment).build()
  }
  def asReadOnly: SavingsPlansPurchaseRecommendationSummary.ReadOnly = SavingsPlansPurchaseRecommendationSummary.wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendationSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansPurchaseRecommendationSummary = SavingsPlansPurchaseRecommendationSummary(estimatedROIValue.map(value => value), currencyCodeValue.map(value => value), estimatedTotalCostValue.map(value => value), currentOnDemandSpendValue.map(value => value), estimatedSavingsAmountValue.map(value => value), totalRecommendationCountValue.map(value => value), dailyCommitmentToPurchaseValue.map(value => value), hourlyCommitmentToPurchaseValue.map(value => value), estimatedSavingsPercentageValue.map(value => value), estimatedMonthlySavingsAmountValue.map(value => value), estimatedOnDemandCostWithCurrentCommitmentValue.map(value => value))
    def estimatedROIValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def estimatedTotalCostValue: scala.Option[primitives.GenericString]
    def currentOnDemandSpendValue: scala.Option[primitives.GenericString]
    def estimatedSavingsAmountValue: scala.Option[primitives.GenericString]
    def totalRecommendationCountValue: scala.Option[primitives.GenericString]
    def dailyCommitmentToPurchaseValue: scala.Option[primitives.GenericString]
    def hourlyCommitmentToPurchaseValue: scala.Option[primitives.GenericString]
    def estimatedSavingsPercentageValue: scala.Option[primitives.GenericString]
    def estimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString]
    def estimatedOnDemandCostWithCurrentCommitmentValue: scala.Option[primitives.GenericString]
    def estimatedROI: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedROI", estimatedROIValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def estimatedTotalCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedTotalCost", estimatedTotalCostValue)
    def currentOnDemandSpend: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentOnDemandSpend", currentOnDemandSpendValue)
    def estimatedSavingsAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedSavingsAmount", estimatedSavingsAmountValue)
    def totalRecommendationCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalRecommendationCount", totalRecommendationCountValue)
    def dailyCommitmentToPurchase: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dailyCommitmentToPurchase", dailyCommitmentToPurchaseValue)
    def hourlyCommitmentToPurchase: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hourlyCommitmentToPurchase", hourlyCommitmentToPurchaseValue)
    def estimatedSavingsPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedSavingsPercentage", estimatedSavingsPercentageValue)
    def estimatedMonthlySavingsAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlySavingsAmount", estimatedMonthlySavingsAmountValue)
    def estimatedOnDemandCostWithCurrentCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedOnDemandCostWithCurrentCommitment", estimatedOnDemandCostWithCurrentCommitmentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary) extends SavingsPlansPurchaseRecommendationSummary.ReadOnly {
    override def estimatedROIValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedROI()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
    override def estimatedTotalCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedTotalCost()).map(value => value: primitives.GenericString)
    override def currentOnDemandSpendValue: scala.Option[primitives.GenericString] = scala.Option(impl.currentOnDemandSpend()).map(value => value: primitives.GenericString)
    override def estimatedSavingsAmountValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedSavingsAmount()).map(value => value: primitives.GenericString)
    override def totalRecommendationCountValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalRecommendationCount()).map(value => value: primitives.GenericString)
    override def dailyCommitmentToPurchaseValue: scala.Option[primitives.GenericString] = scala.Option(impl.dailyCommitmentToPurchase()).map(value => value: primitives.GenericString)
    override def hourlyCommitmentToPurchaseValue: scala.Option[primitives.GenericString] = scala.Option(impl.hourlyCommitmentToPurchase()).map(value => value: primitives.GenericString)
    override def estimatedSavingsPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedSavingsPercentage()).map(value => value: primitives.GenericString)
    override def estimatedMonthlySavingsAmountValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlySavingsAmount()).map(value => value: primitives.GenericString)
    override def estimatedOnDemandCostWithCurrentCommitmentValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedOnDemandCostWithCurrentCommitment()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary): ReadOnly = new Wrapper(impl)
}