package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RightsizingRecommendationSummary(totalRecommendationCount: scala.Option[primitives.GenericString] = None, estimatedTotalMonthlySavingsAmount: scala.Option[primitives.GenericString] = None, savingsCurrencyCode: scala.Option[primitives.GenericString] = None, savingsPercentage: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary = {
    import RightsizingRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary.builder().optionallyWith(totalRecommendationCount.map(value => value: java.lang.String))(_.totalRecommendationCount).optionallyWith(estimatedTotalMonthlySavingsAmount.map(value => value: java.lang.String))(_.estimatedTotalMonthlySavingsAmount).optionallyWith(savingsCurrencyCode.map(value => value: java.lang.String))(_.savingsCurrencyCode).optionallyWith(savingsPercentage.map(value => value: java.lang.String))(_.savingsPercentage).build()
  }
  def asReadOnly: RightsizingRecommendationSummary.ReadOnly = RightsizingRecommendationSummary.wrap(buildAwsValue())
}
object RightsizingRecommendationSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RightsizingRecommendationSummary = RightsizingRecommendationSummary(totalRecommendationCountValue.map(value => value), estimatedTotalMonthlySavingsAmountValue.map(value => value), savingsCurrencyCodeValue.map(value => value), savingsPercentageValue.map(value => value))
    def totalRecommendationCountValue: scala.Option[primitives.GenericString]
    def estimatedTotalMonthlySavingsAmountValue: scala.Option[primitives.GenericString]
    def savingsCurrencyCodeValue: scala.Option[primitives.GenericString]
    def savingsPercentageValue: scala.Option[primitives.GenericString]
    def totalRecommendationCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalRecommendationCount", totalRecommendationCountValue)
    def estimatedTotalMonthlySavingsAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedTotalMonthlySavingsAmount", estimatedTotalMonthlySavingsAmountValue)
    def savingsCurrencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsCurrencyCode", savingsCurrencyCodeValue)
    def savingsPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPercentage", savingsPercentageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary) extends RightsizingRecommendationSummary.ReadOnly {
    override def totalRecommendationCountValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalRecommendationCount()).map(value => value: primitives.GenericString)
    override def estimatedTotalMonthlySavingsAmountValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedTotalMonthlySavingsAmount()).map(value => value: primitives.GenericString)
    override def savingsCurrencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.savingsCurrencyCode()).map(value => value: primitives.GenericString)
    override def savingsPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.savingsPercentage()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary): ReadOnly = new Wrapper(impl)
}